### 概述

OPCUA 是一种用于不同设备和系统之间进行通信的技术规范。通过OPCUA Client可以请求OPCUA Server数据，然后进行读写，实现各种设备和系统互相交流和共享数据，实现更高效的工业自动化。

**使用场景**
* 广泛应用于工业自动化和物联网领域

**整体架构**
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af5250892.png)

**主要功能及产品组件**

注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

下表概述了各个产品组件

| **产品组件**                                 | **描述说明**           |
| ---------------------------------------- | ------------------ |
| sf4300-opcua\_0.0.3-rc.2\_amd64.deb      | Opcua client RTE组件 |
| Sinsegye.Ide.Opcuaeditor.plugin\_0.0.3.0 | MetaFacture 插件     |

---
### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 工智机可以访问互联网；

* 熟悉基础的Linux操作命令;


**安装过程**

**1、工智机端安装OPCUA Client RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

* 修改RTE的配置文件，ComponentManger字段下加入sf4300\_opcua

* 重启RTE服务，使新加入的sf4300\_opcua被调用

**2、MetaFacature安装opcua client插件**

* MetaFacture中点击“工具” -- “组件管理器”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af6061363.png)

* 点击“离线安装” -- 按照提示点击“确定” 关闭MetaFacture；
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af66ceb94.png)

* 选中opcua clinet的插件，点击“打开”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af75e8119.png)

* 安装完成后提示“已安装完成”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af7cdb4c9.png)


**更新安装**

**1、工智机端更新OPCUA Client RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

* 重启RTE服务，使新升级的sf4300\_opcua生效

**2、MetaFacature升级opcua client插件**

* MetaFacture中点击“工具” -- “组件管理器”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af8631c20.png)

* 搜索旧的opcua client插件，选中后点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af91a81ac.png)

* 点击“离线安装” -- 按照提示点击“确定” 关闭MetaFacture；
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af989c1fd.png)


* 选中新的opcua client的插件，点击“打开”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800af9f54605.png)

* 安装完成后提示“已安装完成”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afa5299bf.png)


**卸载过程**

**1、卸载opcua client RTE组件**

* 工智机上执行命令卸载opcua client RTE组件

* 修改RTE的配置文件，ComponentManger字段下去掉sf4300\_opcua

* 重启RTE服务

**2、MetaFacature卸载opcua client插件**

* MetaFacture中点击“工具” -- “组件管理器”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afb031dce.png)


* 搜索旧的opcua client插件,选中后点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afb6e70f3.png)



---
### 技术说明

**快速启动**

 **本例软、硬件配置**

**硬件：**

1. SX5100工智机 MetaOS V24.08.15\_SX5

2. Win10 PC



**软件：**

1. MetaFacutre V1.0.6.2

2. 第三方opcua server

**本例实验要求及原理**

* 实验要求：按照“安装卸载”部分中的“安装过程”配置完成OPCUA Client环境

**1、实验原理**
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afbfdb237.png)


* 当MetaFacture作为OPC UA Client时，可以访问本地/远程的OPC-UA Servers里面的数据，便于工智机和第三方设备通过OPC UA的方式快速通信。

* 上位机和工智机使用EtherNet连接。

* 上位机上，MetaFacture下装工程到工智机。工程中会包含下面的试验操作步骤中的配置。

* 工智机与第三方opcua server通过EtherNet连接。

**本例实验操作步骤**

**1、工程中创建opcua client实验步骤如下：**

* Metafacture工程中右键“Application”，点击“添加对象” 选择“OPC UA”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afc6acc4e.png)


* 新建client完成后，双击新建的Client, “服务端url”中输入opcua server的地址，点击获取变量；
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afcea75dd.png)


* 获取变量完成后提示“节点加载完成”，并在数据源框中显示了server中的点位；
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afd60af1a.png)


**2、OPCUA Client添加读变量**

* OPCUA\_Client\_setting中数据源勾选中OPCUA Server中变量，点击“添加读变量”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afdd954d7.png)


* 添加完成后，左下方状态由“读变量加载中”变为“读变量加载完成”，右侧的读变量区域也显示了对应的变量信息
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afe4a14de.png)


**3、OPCUA Client添加写变量**

* OPCUA\_Client\_setting中数据源勾选中OPCUA Server中变量，点击“添加写变量”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800afeb210c8.png)


* 添加完成后，左下方状态由“写变量加载中”变为“写变量加载完成”，右侧的写变量区域也显示了对应的变量信息
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800aff0d1f5c.png)

**4、Client删除变量**

* OPCUA\_Client\_Setting界面，在未点击左下角“完成”之前可以在“读变量”或“写变量”区域中选中想要删除的变量，点击“删除变量”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800aff7c0316.png)


* 删除完成后，“读变量”和“写变量”的区域中不存在已经删除的变量

**5、配置映射模式**

**5.1 手动模式**

* OPCUA Client完成读写变量添加后，左下角中选中“手动映射方式” ，点击“完成”；配置完成后的界面新增了“OPCUA\_Client(Data)部分”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800affdcf70c.png)


* 可在OPCUA\_Client(Data)中的“SF4003opcuaIoDrvI/O映射”中的每个通道中添加工程中的变量，与OPCUA Client读写的OPCUA Server变量进行绑定；
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800b00670c93.png)


**5.2 自动模式**

* OPCUA Client完成读写变量添加后，左下角中选中“手动映射方式” ，点击“完成”；配置完成后的界面新增了四部分内容“OPCUA\_Client\_GVL”、“OPCUA\_Client\_PRG”、“OPCUA\_Client\_Data\_Task”、“OPCUA\_Client(Data)”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800b00bb011c.png)


* 自动模式下OPCUA\_Client(Data)中的SF4003opcuaIoDrvI/O映射中已经自动完成了映射配置
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800b01276283.png)


**实验注意点**

* 实验有先后顺序要求，建议按照"实验操作步骤"顺序依次实验；

---
**OPCUA Client支持的变量类型**

| 数据类型            | 是否支持 | 数组是否支持 | 结构体是否支持 |
| --------------- | ---- | ------ | ------- |
| BOOL            | 支持| 支持 | 支持|
| BYTE            | 支持| 支持 | 支持|
| WORD            | 支持| 支持 | 支持|
| DWORD          | 支持| 支持 | 支持|
| Lword           | 支持| 支持 | 支持|
| SINT            | 支持| 支持 | 支持|
| USINT           | 支持| 支持 | 支持|
| INT             | 支持| 支持 | 支持|
| UINT           | 支持| 支持 | 支持|
| DINT            | 支持| 支持 | 支持|
| UDINT           | 支持| 支持 | 支持|
| LINT            | 支持| 支持 | 支持|
| ULINT           | 支持| 支持 | 支持|
| STRING         | 支持| 支持 | 支持|
| WSTRING         | 支持| 支持 | 支持|
| REAL            | 支持| 支持 | 支持|
| LREAL           | 支持| 支持 | 支持|
| TIME\_OF\_DAY   | 支持| 支持 | 支持|
| DATE\_AND\_TIME | 不支持  | 不支持    | 不支持     |
| DATE            | 不支持  | 不支持    | 不支持     |

**工程支持配置多个OPCUA Client**

* 表格中记录的是实测正常的情况

| OPCUA Client数量 | Clinet连接的OPCUA Server情况     | 支持情况 |
| -------------- | --------------------------- | ---- |
| 2              | 不同Client连接同一个的OPCUA Server  | 支持   |
| 2              | 不同Client分别连接不同的OPCUA Server | 支持   |

---
### 错误诊断

**OPCUA Client工程运行后“OPCUA\_Client\_setting”中的“服务器状态”显示“服务器连接失败”**
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800b02260730.png)


* 分析：建议排查OPCUA Server的服务状态以及网络状态；OPCUA Server的服务状态以及网络状态均恢复正常后，OPCUA Client中“服务器状态”可自动恢复为“服务器连接成功”
![](https://resource.helplook.net/docker_production/3648ne/article/7KkRSw0w/6800b02862a1b.png)